//
//  Styling.swift
//  VecoreSDKDemo
//
//  Created by Ramon Swilem on 19/09/2019.
//  Copyright © 2019 Ramon Swilem. All rights reserved.
//

import SwiftUI

extension Font {
    static var vecoreRegular: Font {
        get {
            custom("Source Sans Pro", size: 14.0)
            .weight(.regular)
        }
    }
    
    static var vecoreSubheading: Font {
        get {
            custom("Source Sans Pro", size: 22.0)
            .weight(.regular)
        }
    }
    
    static var vecoreBold: Font {
        get {
            custom("Source Sans Pro", size: 16.0)
            .weight(.semibold)
        }
    }
}

struct PrimaryButton: ViewModifier {
    func body(content: Content) -> some View {
        content
            .padding()
            .frame(minWidth: 200, maxWidth: 400)
            .background(Color.vecorePurple)
            .foregroundColor(Color.white)
            .font(Font.vecoreBold)
            .cornerRadius(6)
    }
}

struct AlternateButton: ViewModifier {
    func body(content: Content) -> some View {
        content
            .padding()
            .frame(minWidth: 200, maxWidth: 400)
            .background(Color.white)
            .foregroundColor(Color.vecorePurple)
            .font(Font.vecoreBold)
            .overlay(RoundedRectangle(cornerRadius: 6).stroke(lineWidth: 3).foregroundColor(Color.vecorePurple))
    }
}

extension Color {
    static var vecorePurple: Color {
        get {
            Color(red: 0x9B / 255, green: 0x28 / 255, blue: 0x7D / 255)
        }
    }
    
    static var vecoreYellow: Color {
        get {
            Color(red: 0xD4 / 255, green: 0x86 / 255, blue: 0x25 / 255)
        }
    }
    
    static var vecoreGray: Color {
        get {
            Color(red: 0x2C / 255, green: 0x3E / 255, blue: 0x50 / 255)
        }
    }
}

struct Header: View {
    var body: some View {
        HStack {
            Image("vecore-logo")
                .resizable()
                .aspectRatio(contentMode: .fit)
                .frame(maxWidth: 100)
            Text("SDK Demo application")
                .foregroundColor(Color.vecoreGray)
                .bold()
                .font(.vecoreBold)
        }
        .padding(.horizontal, -15)
        .padding(.bottom, 50)
    }
}
